 ; Ŀ
 ;   Np - plot a drawing, Bap - plot a directory of drawings.              
 ;   Reads plot settings from the file Pdata.txt in the directory          
 ;   which contains the drawing being plotted.                             
 ;   Now allows local overrides to be placed in Pdata.local which is       
 ;   placed in the directory with Acad.exe.                                
 ;   Also allows pointers from either data file to the same key value      
 ;   in another file.  Those in Pdata.local take precedence.               
 ;   Bap writes a script file to run np on each drawing in the current     
 ;   directory, which is like running Np with Fang but with no options.    
 ;   Copyright 1995, 1997, 1999, 2001 - 2006 by Rocket Software Ltd.       
 ;                                                                         
 ;   Unless you like to do boring work while your computer has coffee.     
 ; 

 ; Ŀ
 ;   Bap - The evil mastermind.                                            
 ;   Calls Dirj and Stoka.  Writes a script which calls Np.                
 ; 
 (DEFUN C:BAP (/ flist prefa numlin eoq conf s start)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Call Dirj to get the list of files and the directory path.            
 ; 
  (setq flist (dirj))
  (setq prefa (car flist))
  (setq flist (cadr flist))
 ; Ŀ
 ;   Should now have a file name and a matching data file.                 
 ; 
  (setq numlin (length flist))
 ; Ŀ
 ;   Set the Quit or End flag to Quit.  (End = T)                          
 ; 
  (setq eoq ())
 ; Ŀ
 ;   Initialise quit or end confirmation string for script file.           
 ; 
  (setq conf (strcat "         (if (/= (getvar \"dbmod\") 0)"
                     "\n             (command \"" (if eoq "N" "Y") "\")"
                     "\n             (princ))"))
 ; Ŀ
 ;   Initialise start time variable for Timme.                             
 ; 
  (setq s (getvar "date"))
  (setq start (* 86400.0 (- s (fix s))))          ; start time for timer
 ; Ŀ
 ;   Write the script file.                                                
 ; 
  (stoka prefa flist conf eoq numlin start)
 ; Ŀ
 ;   Run Fiat_lux, end.                                                    
 ; 
  (command "script" (strcat prefa "Fiat_lux"))
 (princ))
 ; Ŀ
 ;   C:Bap end.                                                            
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   a list of the (possibly modified) target string and the number of     
 ;   changes made.                                                         
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug end.                                                             
 ; 

 ; Ŀ
 ;   Old and more generally useful version.  Saved for future reuse.       
 ;   Combls - combine two lists, give precedence to the first one.         
 ;   Arguments: Lista, the list containing the preferred values.           
 ;              Listb, the second list.                                    
 ;   Returns a combined list.                                              
 ; 
; (DEFUN COMBLS (lista listb / sub)
;  (while (setq sub (car listb))
;         (setq listb (cdr listb))
;         (if (not (assoc (car sub) lista))
;             (setq lista (cons sub lista))))
; lista)
 ; Ŀ
 ;   Combls end.                                                           
 ; 

 ; Ŀ
 ;   Combls - combine two lists, give precedence to the first one.         
 ;   Lists: ("title block" *) are added no matter what, if the sublist     
 ;   in Lista starts with "file " then the pointer didn't work so the      
 ;   sublist from ListB is added in the hope that it is correct.           
 ;   Arguments: Lista, the list containing the preferred values.           
 ;              Listb, the second list.                                    
 ;   Returns a combined list.                                              
 ; 
 (DEFUN COMBLS (lista listb / sub)
  (while (setq sub (car listb))
         (setq listb (cdr listb))
         (setq asoca (assoc (car sub) lista))
 ; Ŀ
 ;   Cond: if the value from Listb doesn't match a value in Lista then     
 ;   add it to lista.                                                      
 ; 
         (cond ((= (car asoca) "title block")
                (setq lista (cons sub lista)))
 ; Ŀ
 ;   Cond: if the value from Listb doesn't match a value in Lista then     
 ;   add it to lista.                                                      
 ; 
               ((null (car asoca))
                (setq lista (cons sub lista)))
 ; Ŀ
 ;   Cond: if the value from Listb matches a value in Lista and the        
 ;   latter begins with "File " then the pointer file or value was         
 ;   missing, so replace the value in Lista with the value from Listb,     
 ;   which might possibly be right.                                        
 ; 
               ((= (strcase (substr (cadr asoca) 1 5) t) "file ")
                (setq lista (subst sub asoca lista)))))
 lista)
 ; Ŀ
 ;   Combls end.                                                           
 ; 

 ; Ŀ
 ;   Dirj - get a list of drawing filenames in the current directory.      
 ;   Currently takes no arguments.                                         
 ;   Returns a list: the path, and a list of filenames with paths.         
 ; 
 (DEFUN DIRJ (/ pat pref fils num fnam nulis)
  (setq pat "*.dwg")
  (setq pref (getvar "dwgprefix"))
  (setq fils (vl-directory-files pref pat 1))
 ; Ŀ
 ;   Put the filename list in alphabetical order.                          
 ; 
  (setq fils (acad_strlsort fils))
  (setq num 0)
 ; Ŀ
 ;   Add the directory prefix to each name.                                
 ; 
  (while (and fils (setq fnam (nth num fils)))
         (setq num (1+ num))
         (setq fnam (strcat pref fnam))
         (setq nulis (cons fnam nulis)))
 (list pref (reverse nulis)))
 ; Ŀ
 ;   Dirj end.                                                             
 ; 

 ; Ŀ
 ;   Fispp - find out which space the title block occupies.                
 ;   Contains an internal list of blocks, if any one is found in the       
 ;   drawing then the space it occupies is taken as the one to plot.       
 ;   No provision is made for choosing between multiple paper space        
 ;   layouts.                                                              
 ;   Takes one argument, Tblist, a list of title block names.              
 ;   Calls nothing.                                                        
 ;   Returns a list of tabs containing title blocks.                       
 ; 
 (DEFUN FISPP (tblist / blnam ss enam datab num prisp)
 ; Ŀ
 ;   Add the list of title blocks from the config file (if any) to the     
 ;   internal list of known titleblocks.  Those from the config file       
 ;   take prcedence, the process continues only until the first tb has     
 ;   been found.                                                           
 ; 
  (setq tblist (append tblist
                '("a4_border" "accutb" "aeca1tb" "amw_title" "atbased"
                  "bomp3"
                  "colleauxtb" "coltma1c" "c-dfmttxt" "csnewblk" "cstblk_d"
                  "d-bord-e" "devon-d" "d-gen-l"
                  "encana iso border-1"
                  "fci-encana"
                  "gac" "gca1tb" "gca3ltb" "gca3-cad" "gei1line"
                  "geia0tb" "geia1tb" "geia3itb" "geia3ltb" "geielctb"
                  "gela1tb" "geltitle" "gema1tb" "gulf1"
                  "horz_2dborda1" "husky_a1"
                  "icaltblk"
                  "IFCDATE2" "IFCDATE3" "IFCDATE4"
                  "maintb" "meg-a194"
                  "pcpa1" "pcp-a1" "pennwest_a1_titleblock" "pennwest_d_titleblock"
                  "pvrsht-a3"
                  "repl-a1"
                  "t2a" "t2a-3" "t-a001c" "t-a002a" ; "tb"
                  "tblock" "titleblk"
                  "title block new"
                  "TRIDYNE_LOGO_D" "TRIDYNE_TB_D")))
 ; Ŀ
 ;   Keep looking until the list has been exhausted or a block is          
 ;   present in the block tables and inserted in the drawing.              
 ; 
  (while (and (setq blnam (car tblist))
              (or (null (tblsearch "block" blnam))
                  (null (setq ss (ssget "x" (list (cons 2 blnam)))))))
         (setq tblist (cdr tblist)))
 ; Ŀ
 ;   Make a list of the tab name of each space contining a tb, if none     
 ;   is found return a list containing only model space.                   
 ; 
  (if (null ss)
      (progn
           (write-line "\nNo titleblock found - plotting Model tab.")
           (setq prisp '("Model")))
      (progn
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq num (1+ num))
                  (setq datab (cdr (assoc 410 (entget enam))))
                  (setq prisp (cons datab prisp)))))
 prisp)
 ; Ŀ
 ;   Fispp end.                                                            
 ; 

 ; Ŀ
 ;   Mint - Convert seconds to hours, minutes and seconds.                 
 ; 
 (DEFUN MINT (sec / hours mins)
  (setq hours (itoa (fix (/ sec 3600))))
  (setq sec (rem sec 3600))
  (setq mins (itoa (fix (/ sec 60))))
  (setq sec (itoa (fix (rem sec 60))))
  (if (= (strlen hours) 1) (setq hours (strcat "0" hours)))
  (if (= (strlen mins) 1) (setq mins (strcat "0" mins)))
  (if (= (strlen sec) 1) (setq sec (strcat "0" sec)))
  (strcat hours ":" mins ":" sec))
 ; Ŀ
 ;   Mint end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Nopth - remove the path from a filename.                   
 ; 
 (DEFUN NOPTH (tt / pos)
  (setq pos (strlen tt))                          ; start at end of the string
  (while (< 0 pos)
          (if (or (= (substr tt pos 1) (chr 92))  ; if char = \
                  (= (substr tt pos 1) ":"))      ; if char = :
             (progn
                   (setq tt (substr tt (1+ pos))) ; then set tt to all after
                   (setq pos 1)))                 ;  and set pos to first
         (setq pos (1- pos)))                     ; set pos to previous
  tt)
 ; Ŀ
 ;   Nopth end.                                                            
 ; 

 ; Ŀ
 ;   Nopath - returns the drawing name without the extension.              
 ; 
 (DEFUN NOPATH ( / dwgnam)
  (setq dwgnam (strcase (getvar "dwgname")))
  (if (= (substr dwgnam (- (strlen dwgnam) 3)) ".DWG")
      (setq dwgnam (substr dwgnam 1 (- (strlen dwgnam) 4))))
 dwgnam)
 ; Ŀ
 ;   Nopath end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Othf - see if any config file setting was a pointer to     
 ;   another file.                                                         
 ;   Arguments: Conffa, the configuration list returned by Prif.           
 ;   Calls Prif, Returns a possibly modified list.                         
 ; 
 (defun othf (conffa / num kevala sub nuffa nulist)
  (setq num 0)
  (while (setq sub (nth num conffa))
         (setq num (1+ num))
         (setq asoc (car sub))
         (setq kevala (cadr sub))
 ; Ŀ
 ;   It would be more elegant to simply see if each value is a file, but   
 ;   a value might be the name of a file in the Acad search path, which    
 ;   would result in it being used as a data file, which would be bad.     
 ;   Note that the secondary file must use the same format as the main     
 ;   one, and so can contain multiple values, but only the one associated  
 ;   with the value in question will be used.                              
 ; 
         (if (= (strcase (substr kevala 1 4) t) "file")
             (if (and (setq nuffa (findfile (substr kevala 6)))
                      (setq nuconf (prif nuffa "="))
                      (setq vala (cadr (assoc asoc nuconf))))
                 (setq sub (list asoc vala))
                 (prompt (strcat "Secondary config value: "
                                 (strcase asoc) " not available.\n"))))
         (setq nulist (cons sub nulist)))
 nulist)
 ; Ŀ
 ;   Subroutine Othf end.                                                  
 ; 

 ; Ŀ
 ;   Subroutine Pcga: plot with the previous settings.                     
 ;   Arguments: None.  Sorry.                                              
 ;              On second thought: Printa, the printer pc3 file name.      
 ;              And Sava, save settings to page/etc. (Y/N)                 
 ;   Calls nothing, Returns nothing.                                       
 ;   Possibly this should be modified to allow plotting to a file.         
 ; 
 (DEFUN PCGA (printa sava)
  (command "plot")                ; fairly self-evident
  (command "n")                   ; detailed plot configuration?
  (command "")                    ; layout name or [?] <Layout1>
  (command "<Previous plot>")     ; page setup name <>: 
  (command printa)                ; output device name or [?] <G006.pc3>:
  (command "N")                   ; plot to a file?
  (command sava)                  ; Save changes to page setup [Yes/No]?
  (command "Y")                   ; Proceed with plot?
 (princ))
 ; Ŀ
 ;   Subroutine Pcga end.                                                  
 ; 

 ; Ŀ
 ;   Subroutine Pcqa: call the plot command.                               
 ;   Arguments: Deva, the output device .pc3 file name.                    
 ;              Psize, the paper size.                                     
 ;              Unitz, the units to use (mm or inches).                    
 ;              Pstyle, the plot style .ctb file name.                     
 ;              Ploto, plot area (typically Extents or Limits).            
 ;              Orient, drawing orientation, typically Landscape.          
 ;              Offset, the plot offset, typically Center.                 
 ;              Outmin, Outmax, if these two are non-nil plot to a         
 ;                      window using them as corners.                      
 ;              Plofi, the file name to plot to.                           
 ;              Sava, Y/N, save settings to model/layout/page setup.       
 ;                                                                         
 ;   Calls nothing, Returns nothing, chews gum.                            
 ; 
 (DEFUN PCQA (deva psize unitz pstyle ploto orient offset outmin outmax plofi
                                                                        sava)
  (command "plot")                ; fairly self-evident
  (command "y")                   ; detailed plot configuration?
 ; Ŀ
 ;   Np makes the layout to plot current, this then becomes the default    
 ;   so there is no need to specify one.                                   
 ; 
  (command "")                    ; layout name or [?]
  (command deva)                  ; output device name (i.e. a .pc3 file)
  (command psize)                 ; paper size
  (command unitz)                 ; paper units - unchangedp if plotting to fit
  (command orient)                ; dwg orientation (landscape or letter)
  (command "N")                   ; plot upside down?
 ; Ŀ
 ;   Plot area: If Outmin and Outmax are set then plot to a window.        
 ;   This overrides Ploto.                                                 
 ;   If we are in paper space then unless the display settings have been   
 ;   changed we can't plot to (or set) limits.  This being the case,       
 ;   plot to extents instead and hope there is nothing outside the tb.     
 ;   *** Might also see if limits are set (or can be set) in ps and if so  
 ;   plot to them if ploto is set to limits. ***                           
 ; 
  (cond ((and outmin outmax)
         (command "window" outmin outmax))
        ((and (= (getvar "tilemode") 0)       ; we are in ps
              (= (strcase ploto t) "limits")) ; and trying to plot to limits
         (command "extents"))                 ; plot to extents instead
        (t
         (command ploto)))                    ; else plot extents, limits, etc.
 ; Ŀ
 ;   Back in reality...                                                    
 ; 
  (command "Fit")                 ; plot scale
  (command offset)                ; plot offset (typically center)
  (command "Yes")                 ; plot with plot styles?
  (command pstyle)                ; plot style table (. for none)
  (command "Y")                   ; plot with lineweights?
 ; Ŀ
 ;   If we are in a paper space tab:                                       
 ; 
  (if (= (getvar "tilemode") 0)   ; if we are in a paper space tab
      (progn
           (command "N")          ; scale lineweights with plot scale?
           (command "N")          ; plot paper space first?
           (command "N"))         ; hide paperspace objects?
 ; Ŀ
 ;   If we are in the model space tab:                                     
 ;   Enter shade plot setting [As displayed/Wireframe/Hidden/Rendered]     
 ;   <As displayed>:                                                       
 ; 
      (command "n"))                   ; remove hidden lines?
 ;     (command "As displayed")   ; Enter shade plot setting - 2005
 ; Ŀ
 ;   Final settings, proceed.                                              
 ; 
  (if plofi
     (progn
          (command "Y")           ; plot to a file
          (command plofi))        ; file name
     (command "N"))               ; don't plot to a file
  (command sava)                  ; Save changes to model/layout/page setup?
  (command "Y")                   ; Proceed with plot?
 (princ))
 ; Ŀ
 ;   Subroutine Pcqa end.                                                  
 ; 

 ; Ŀ
 ;   Plost - see if a drawing is in named or coloured plot style mode.     
 ;   Takes no arguments, returns c or n.                                   
 ;                                                                         
 ;   According to the manual if the current drawing is in colour           
 ;   dependent plot mode then PstylePolicy is set to 1.                    
 ;   This doesn't work.                                                    
 ;   But the Cplotstyle sysvar "controls the current plot style for new    
 ;   objects."  If you are in color-dependent mode then CplotStyle is      
 ;   read-only and has a value of "Bycolor."  If the drawing is in named   
 ;   plot styles mode then CplotStyle can be set to the following values:  
 ;   Bylayer (the default), Byblock, Normal, or User Defined.              
 ;   So we can deduce which state the drawing is in and convert it to      
 ;   colour dependent mode (with ConvertPstyles) if necessary.             
 ;   Converting the other way can wait until colour plotters become more   
 ;   common.  Or idiots become more influential.                           
 ;   Convertpstyles asks for a named (.stb) penweight file when going to   
 ;   named plot styles, but doesn't ask for one going to coloured.         
 ; 
 (DEFUN PLOST ()
  (if (= (strcase (getvar "cplotstyle") t) "bycolor") "c" "n"))
 ; Ŀ
 ;   Plost end.                                                            
 ; 

 ; Ŀ
 ;   Prif - extract information from a config file.                        
 ;   Arguments: Fnamp, a configuration file name.                          
 ;              Sepia, the character separating each tag and value.        
 ;   Looks for the file first in the directory containing the current      
 ;   drawing, then anywhere in the acad search path.                       
 ;   Ignores comments, removes leading and trailing spaces.                
 ;   Returns a list of lists: ((key  value) ... ) or nil.                  
 ; 
 (DEFUN PRIF (fnamp sepia / fnam fn str len prawn sub cflhst)
 ; Ŀ
 ;   See if the data file is available; if so then read it into a list.    
 ; 
  (if (or (setq fnam (findfile (strcat (getvar "dwgprefix") fnamp)))
          (setq fnam (findfile fnamp)))
      (progn
 ; Ŀ
 ;   Indicate which printer control file was found.                        
 ; 
           (prompt (strcat "\nUsing configuration file: " fnam "\n"))
 ; Ŀ
 ;   Open the file, save the handle.                                       
 ; 
           (setq fn (open fnam "r"))
 ; Ŀ
 ;   While there are lines in the file, process them.                      
 ; 
           (while (and (null prawn) (setq str (read-line fn)))
 ; Ŀ
 ;   Kill leading spaces.                                                  
 ; 
                  (while (and (= (substr str 1 1) " ")
                              (/= (strlen str) 0))
                         (setq str (substr str 2)))
                  (while (and (/= str "")
                              (= (substr str (setq len (strlen str))) " "))
                         (setq str (substr str 1 (1- len))))
 ; Ŀ
 ;   If the line isn't a comment or empty, proceed.                        
 ; 
                  (if (and (/= (substr str 1 1) ";")
                           (/= str ""))
                      (progn
 ; Ŀ
 ;   Split at semicolons (if any), ditch all but the first substring.      
 ; 
                           (setq str (car (splat ";" str)))
 ; Ŀ
 ;   Ditch trailing spaces.                                                
 ; 
                           (while (= (substr str (setq len (strlen str))) " ")
                                  (setq str (substr str 1 (1- len))))
 ; Ŀ
 ;   Split at separateo characters, make into a list.                      
 ; 
                           (setq sub (splat sepia str))
 ; Ŀ
 ;   Decapitalize the first string in sub, make into a dotted pair.        
 ; 
                           (setq sub (cons (strcase (car sub) t) (cdr sub)))
 ; Ŀ
 ;   Add the sublist to the master list.                                   
 ; 
                           (setq cflhst (cons sub cflhst)))))
 ; Ŀ
 ;   Close the data file, return the data list.                            
 ; 
           (close fn)))
 cflhst)
 ; Ŀ
 ;   Prif end.                                                             
 ; 

 ; Ŀ
 ;   Spath - split a path and filename string into a path and a filename.  
 ; 
 (DEFUN SPATH (tt / pos pp)
 ; Ŀ
 ;   Set the pointer Pos to the end of the string.                         
 ; 
  (setq pos (strlen tt))                            ; start at end of string
 ; Ŀ
 ;   Remove path.                                                          
 ; 
  (while (< 0 pos)
          (if (or (= (substr tt pos 1) (chr 92))    ; if char = \
                  (= (substr tt pos 1) ":"))        ; if char = :
             (progn
                   (setq pp (substr tt 1 pos))      ; then set pp to all before
                   (setq tt (substr tt (1+ pos)))   ;          tt to all after
                   (setq pos 1)))                   ;      and pos to first
         (setq pos (1- pos)))                       ; set pos to previous
 (list pp tt))
 ; Ŀ
 ;   Spath end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string into a list of substrings.    
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ; 
 (DEFUN SPLAT (sepchr linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (= (substr name1 (setq len (strlen name1))) " ")
                (setq name1 (substr name1 1 (1- len))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Stoka - write the script file Fiat_lux.scr for Bap.lsp.    
 ;   Arguments: Prefa,  the script file location.                          
 ;              Filist, the file name list.                                
 ;              Conf,   the end or quit string.                            
 ;              Eoq,    the End or Quit each drawing flag.                 
 ;   And two arguments to be written into the script file for Timme:       
 ;              Numlin, the total number of drawings.                      
 ;              Start,  the start time.                                    
 ;                                                                         
 ;   Calls Nopth, returns nothing.                                         
 ; 
 (DEFUN STOKA (prefa filist conf eoq numlin start / fbat numm var lispnm)
  (setq numm 1)
  (setq fbat (open (strcat prefa "fiat_lux.scr") "w"))
  (while (setq var (car filist))
         (setq filist (cdr filist))
 ; Ŀ
 ;   Replace backslashes in the path with double backslashes.              
 ; 
         (setq var (car (chug "\\" "\\\\" var)))
 ; Ŀ
 ;   Write the timer/lap counter code.                                     
 ; 
         (write-line "(if (not timme) (load \"np\"))" fbat)
         (write-line (strcat "(timme " (rtos start 2 2) " " (itoa numlin)
                                               " " (itoa numm) ")") fbat)
 ; Ŀ
 ;   Write the code to turn on single document interface mode.             
 ;   This will be added before each Open command in case something in      
 ;   the setup turns it back off.                                          
 ; 
         (write-line "(setvar \"sdi\" 1)" fbat)
 ; Ŀ
 ;   Increment the lap counter.                                            
 ; 
         (setq numm (1+ numm))
 ; Ŀ
 ;   See if the drawing is present before opening it.                      
 ; 
         (write-line (strcat "(if (findfile " (chr 34) var (chr 34) ")") fbat)
         (write-line "    (progn " fbat)
 ; Ŀ
 ;   Now write the "open" lines to the script file.                        
 ; 
         (write-line (strcat
                       "         (command " (chr 34) "open" (chr 34)")") fbat)
         (write-line conf fbat)                       ; really discard etc.?
         (write-line (strcat
                       "         (command " (chr 34) var (chr 34) ")))") fbat)
 ; Ŀ
 ;   Check to see if are in the correct drawing before changing anything.  
 ; 
         (write-line (strcat "(if (= (getvar \"dwgname\") \""
                              (nopth var) "\")") fbat)
         (write-line "    (progn" fbat)
 ; Ŀ
 ;   Write the code to load Bap and then run Np.lsp.                       
 ; 
         (write-line "         (load \"np\")" fbat)
         (write-line "         (c:np)))" fbat))
 ; Ŀ
 ;   End of While Filenames loop.  Write the code to set SDI back to       
 ;   what it was, which just happens to be what it is.                     
 ; 
  (setq sdi (getvar "sdi"))
  (write-line (strcat "(setvar \"sdi\" " (itoa sdi) ")") fbat)
 ; Ŀ
 ;   Add the commands to delete the script and either End or Quit.         
 ; 
  (write-line (strcat "shell del " prefa "fiat_lux.scr") fbat)
  (if eoq
     (write-line "END" fbat)
     (progn
          (write-line "Quit" fbat)
          (write-line "Y" fbat)))                    ; really discard etc.?
  (close fbat)
 (princ))
 ; Ŀ
 ;   Stoka end.                                                            
 ; 

 ; Ŀ
 ;   Timme - Script file timer.                                            
 ;   Copyright 1994, 2004 by Rocket Software Ltd.                          
 ;   Software to help alleviate the tedium of mindless labour.             
 ; 
 (DEFUN TIMME (t1 totnum done / s t2 elapse timea timlft elap tleft)
 ; Ŀ
 ;   T1 = start time, Totnum = total drawings, Done = drawings finished    
 ; 
  (setq s (getvar "date"))
  (setq t2 (* 86400.0 (- s (fix s))))
  (setq elapse (- t2 t1))
 ; Ŀ
 ;   Write the lap counter before Done is decremented.                     
 ; 
  (setq done (1- done))   ; decrement - timer called before curr. dwg processed
  (if (> done 0)
      (progn
           (setq timea (/ elapse (float done)))
           (setq timlft (* timea (- totnum done)))
           (setq elap (mint elapse))
           (setq tleft (mint timlft))
           (setvar "modemacro" (strcat (itoa done) "/" (itoa totnum)
                                       "  Time Elapsed: " elap
                                       "  Time Left: " tleft))))
 (princ))
 ; Ŀ
 ;   Timme end.                                                            
 ; 

 ; Ŀ
 ;   Np.                                                                   
 ; 
 (DEFUN NP (previo printa unitz psiaz orient offset plotto pstyle nstyle sava
            plot1 dispo windo force plofi prefx /
            prindt filnam priloc outside minex maxex minx maxx miny maxy len
            percen hite widd outmin outmax num sub tblist ptype fispa tabnam
            sava)
 ; Ŀ
 ;   Read the config file into a list.                                     
 ;   Note that values taken as arguments override values from the config   
 ;   file.                                                                 
 ; 
  (setq prindt (prif "pdata.txt" "="))
 ; Ŀ
 ;   Reprocess it in case any values are pointers to other files.          
 ; 
  (if prindt (setq prindt (othf prindt)))
 ; Ŀ
 ;   Find the file Pdata.local in c:\etc\acad and suck it into a list.     
 ; 
  (if (and (setq filnam (strcat (car (spath (findfile "acad.exe")))
                                "pdata.local"))
           (setq filnam (findfile filnam)))
      (progn
           (setq priloc (prif filnam "="))
 ; Ŀ
 ;   Reprocess it in case any values are pointers to other files.          
 ; 
           (setq priloc (othf priloc))
 ; Ŀ
 ;   Add values from c:\...\pdata.local to the list of configuration       
 ;   values from Pdata.txt.                                                
 ;   Values from Pdata.local override existing ones (i.e. from Pdata.txt), 
 ;   but don't replace values passed as arguments to (np).                 
 ; 
           (setq prindt (combls priloc prindt))))
 ; Ŀ
 ;   Title blocks are a special case - there can be >1 - and are read      
 ;   into their own list, tblist.                                          
 ;   Tblist is later passed as an argument to Fispp, which finds the       
 ;   space containing a title block.  Fispp contains its own tb list       
 ;   which is added to this one.                                           
 ; 
  (setq num 0)
  (while (and prindt (setq sub (nth num prindt)))
         (setq num (1+ num))
         (if (= (car sub) "title block")
             (setq tblist (cons (cadr sub) tblist))))
 ; Ŀ
 ;   Note that Titleblock names from both lists are now combined in the    
 ;   master list Tblist, but they have not been removed from the config    
 ;   list.                                                                 
 ; 
 ; Ŀ
 ;   If no config file is available use the previous settings.             
 ;   Also use the previous settings if the Previous flag was set.          
 ; 
  (cond ((and (null prindt) (null previo))
         (setq previo "on"))
        ((and prindt (null previo))
         (setq previo (cadr (assoc "previous" prindt)))))
  (if previo (prompt "Using previous plot settings.\n"))
 ; Ŀ
 ;   Stuff for which there must be a value - if the value is not set       
 ;   in the config file then try either the default or a standard value.   
 ;   If any values are already set then use them.                          
 ; 
  (if (and (null printa)
           (null (setq printa (cadr (assoc "printer" prindt)))))
      (setq printa ""))
  (if (and (null unitz)
           (null (setq unitz (cadr (assoc "units" prindt)))))
      (setq unitz "Millimeters"))
  (if (and (null psiaz)
           (null (setq psiaz (cadr (assoc "size" prindt)))))
      (setq psiaz ""))
  (if (and (null orient)
           (null (setq orient (cadr (assoc "orientation" prindt)))))
      (setq orient "Landscape"))
  (if (and (null offset)
           (null (setq offset (cadr (assoc "plot offset" prindt)))))
      (setq offset "Center"))
  (if (and (null plotto)
           (null (setq plotto (cadr (assoc "plot to" prindt)))))
      (setq plotto "Extents"))
  (if (and (null pstyle)
           (null (setq pstyle (cadr (assoc "ctb file" prindt)))))
      (setq pstyle ""))
  (if (and (null nstyle)
           (null (setq nstyle (cadr (assoc "stb file" prindt)))))
      (setq nstyle ""))
  (if (and (null sava)
           (null (setq sava (cadr (assoc "save to page" prindt)))))
      (setq sava "N"))
 ; Ŀ
 ;   Optional settings.                                                    
 ; 
  (if (null plot1)
      (setq plot1 (cadr (assoc "plot first tb only" prindt))))
  (if (null dispo)
      (setq dispo (cadr (assoc "plot display only" prindt))))
  (if dispo (setq plotto "Display"))  ; override extents or limits etc.
  (if (null windo)
      (setq windo (cadr (assoc "window" prindt))))
  (if (null force)
      (setq force (cadr (assoc "force to ctb" prindt))))
 ; Ŀ
 ;   If we are plotting to a file, make a plot name and path string.       
 ;   If Plot to file = t then use the current filename as the plot file    
 ;   name, if it is a string then use that.                                
 ;   If Plot directory is set then place the plot there, else use the      
 ;   directory containing the current drawing.                             
 ;   The complete path and filename (minus extension) is stored in the     
 ;   variable Plofi.                                                       
 ; 
  (if (null plofi)
      (setq plofi (cadr (assoc "plot to file" prindt))))
  (if (and plofi (/= (type plofi) 'str))
      (setq plofi (nopath)))
  (if (null prefx)
      (setq prefx (cadr (assoc "plot directory" prindt))))
  (if (and plofi (null prefx))
      (setq prefx (getvar "dwgprefix")))
  (if plofi (setq plofi (strcat prefx plofi)))
 ; Ŀ
 ;   Check for the plot outside extents setting.                           
 ;   This setting overrides Plotto: plot to extents, limits, etc.          
 ;   If either Dispo (plot display) or Windo (plot window) is set then     
 ;   ignore this section.                                                  
 ; 
  (if (and (null dispo) (null windo)
           (setq outside (cadr (assoc "outside extents" prindt))))
      (progn
 ; Ŀ
 ;   Get some extents values, extract the x and y coordinates              
 ; 
           (setq minex (getvar "extmin"))
           (setq maxex (getvar "extmax"))
           (setq minx (car minex))
           (setq maxx (car maxex))
           (setq miny (cadr minex))
           (setq maxy (cadr maxex))
 ; Ŀ
 ;   If the outside value is a percentage then calculate the outside       
 ;   distance as a percentage of the larger of the dwg height or width.    
 ; 
           (cond ((equal (substr outside (setq len (strlen outside))) "%")
                  (setq percen (* 0.01 (read (substr outside 1 (1- len)))))
                  (setq hite (- maxy miny))
                  (setq widd (- maxx minx))
                  (setq outside (* percen (max hite widd))))
 ; Ŀ
 ;   If the outside value is a t and is not zero then must plot to a       
 ;   window - this overrides Ploto even if Ploto is set to extents.        
 ; 
                 ((/= 0 (setq outside (read outside)))
                  (setq outside (* (getvar "dimscale") outside))))
           (setq outmin (list (- minx outside) (- miny outside)))
           (setq outmax (list (+ maxx outside) (+ maxy outside)))))
 ; Ŀ
 ;   If Windo is set then extract the two plot window corners.             
 ; 
  (if windo
      (progn
           (setq outmin (car windo))
           (setq outmax (cadr windo))))
 ; Ŀ
 ;   If the drawing is in Named plot style mode then one requires an .stb  
 ;   file rather than a .ctb file.  Plost returns either c for colour or   
 ;   n for named.                                                          
 ;   One might also consider using the previous good plot settings each    
 ;   time, if this would work with named and coloured plot styles.         
 ; 
  (setq ptype (plost))
 ; Ŀ
 ;   If the previous plot style flag is set then then leave the plot       
 ;   style mode alone.  This may cause problems with different modes,      
 ;   it is not clear what will happen if the previous plot was in the      
 ;   other mode.                                                           
 ; 
  (cond (previo)
        ((= ptype "c"))      ; if coloured then pstyle is ok
        ((and (= ptype "n")  ; if named & (force is set or no stb) force to ctb
              (or force (null nstyle)))
         (command "convertpstyles"))
        ((and (= ptype "n") nstyle) ; if named and stb available then use stb
         (setq pstyle nstyle)))
 ; Ŀ
 ;   See which space each title block occupies, go to that space.          
 ;   If either Dispo or Windo is set then only make one plot, either the   
 ;   current display or the window whose corners are contained in Outmin   
 ;   and Outmax.                                                           
 ; 
  (setq fispa (fispp tblist))
  (setq num 0)
  (cond ((or dispo windo)
         (if previo
             (pcga printa sava)
             (pcqa printa psiaz unitz pstyle plotto orient offset outmin
                                                     outmax plofi sava)))
        (t
         (while (setq tabnam (nth num fispa))
                (setq num (1+ num))
                (setvar "ctab" tabnam)
                (if (and plot1 (/= plot1 "false"))
                    (setq fispa ()))
                (if (/= (strcase tabnam t) "model")
                    (command ".pspace"))
 ; Ŀ
 ;   Plot it.                                                              
 ; 
                (if previo
                    (pcga printa sava)
                    (pcqa printa psiaz unitz pstyle plotto orient offset
                                                outmin outmax plofi sava)))))
 (princ))
 ; Ŀ
 ;   Subroutine Np end.                                                    
 ; 

 ; Ŀ
 ;   Np - calls (np), this allows other functions to call (np) with        
 ;   values which will override those in the config file.                  
 ;   Specifically this allows plotting to a file and multiple window       
 ;   plots in a single drawing.                                            
 ;   Note that these are set to nil in this version: c:np.                 
 ; 
 (DEFUN C:NP (/ previo printa unitz psiaz orient offset plotto pstyle nstyle
                                    sava plot1 dispo windo force plofi prefx)
  (setvar "cmdecho" 0)
  (np previo   ; "previous"            - use previous plot settings
      printa   ; "printer"
      unitz    ; "units"
      psiaz    ; "size"
      orient   ; "orientation"
      offset   ; "plot offset"         - defaults to Center
      plotto   ; "plot to"             - defaults to Extents
      pstyle   ; "ctb file"
      nstyle   ; "stb file"
      sava     ; "save to page"        - defaults to No
      plot1    ; "plot first tb only"
      dispo    ; "plot display only"   - override extents or limits etc.
      windo    ; "window"              - plot to a window
      force    ; "force to ctb"
      plofi    ; "plot to file"
      prefx)   ; "plot directory"
 (princ))

(princ)